﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
namespace Project_management_system
{
    public partial class frmStage : Form
    {
        SqlDataReader rdr = null;
        DataTable dtable = new DataTable();
        SqlConnection con = null;
        SqlCommand cmd = null;
        DataTable dt = new DataTable();
        ConnectionString cs = new ConnectionString();
        clsFunc cf = new clsFunc();
        string st1;
        string st2;
        public frmStage()
        {
            InitializeComponent();
        }

        private void frmStage_Load(object sender, EventArgs e)
        {
            Autocomplete();
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            if (txtStageName.Text == "")
            {
                MessageBox.Show("Please enter Stage name", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                txtStageName.Focus();
                return;
            }


            try
            {
                con = new SqlConnection(cs.ConDB);
                con.Open();
                string ct = "select StageName from Stages where StageName='" + txtStageName.Text + "'";  

                cmd = new SqlCommand(ct);   
                cmd.Connection = con;
                rdr = cmd.ExecuteReader();

                if (rdr.Read())     
                {
                    MessageBox.Show("Stage Name Already Exists", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    txtStageName.Text = "";
                    txtStageName.Focus();


                    if ((rdr != null))    
                    {
                        rdr.Close();
                    }
                    return;
                }

                con = new SqlConnection(cs.ConDB);
                con.Open();

                string cb = "insert into Stages(StageName) VALUES ('" + txtStageName.Text + "')";

                cmd = new SqlCommand(cb);
                cmd.Connection = con;
                cmd.ExecuteReader(); 
                con.Close();
                st1 = lblUser.Text;
                st2 = "added the new Stage '" +txtStageName.Text + "'";
                cf.LogFunc(st1, System.DateTime.Now, st2);
                MessageBox.Show("Successfully saved", "Record", MessageBoxButtons.OK, MessageBoxIcon.Information);
                Autocomplete();     
                btnSave.Enabled = false;

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Do you really want to delete this record?", "Confirmation", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
            {
                delete_records();
            }
        }
        private void delete_records()
        {

        try
            {

              int RowsAffected = 0;
        
              con = new SqlConnection(cs.ConDB);

              con.Open();
              string ct = "select StageID from projectDetails where StageID=@find";


              cmd = new SqlCommand(ct);

              cmd.Connection = con;
              cmd.Parameters.Add(new SqlParameter("@find", System.Data.SqlDbType.Int, 10, "StageID"));


              cmd.Parameters["@find"].Value = txtID.Text;


              rdr = cmd.ExecuteReader();

              if (rdr.Read())
              {
                  MessageBox.Show("Unable to delete..Already use in Project Management Records form", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                  Reset();


                  if ((rdr != null))
                  {
                      rdr.Close();
                  }
                  return;
              }
                con = new SqlConnection(cs.ConDB);
                con.Open();
                string cq = "delete from Stages where ID=" + txtID.Text + "";
                cmd = new SqlCommand(cq);
                cmd.Connection = con;
                RowsAffected = cmd.ExecuteNonQuery();
                if (RowsAffected > 0)
                {
                    st1 = lblUser.Text;
                    st2 = "Deleted the Stage '" + txtStageName.Text + "'";
                    cf.LogFunc(st1, System.DateTime.Now, st2);
                    MessageBox.Show("Successfully deleted", "Record", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    Reset();
                    Autocomplete();
                }
                else
                {
                    MessageBox.Show("No Record found", "Sorry", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    Reset();
                    Autocomplete();
                }
                if (con.State == ConnectionState.Open)
                {
                    con.Close();
                }


            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        private void Autocomplete()
        {
            try
            {
                con = new SqlConnection(cs.ConDB);
                con.Open();
                SqlCommand cmd = new SqlCommand("SELECT distinct Stagename FROM Stages", con);
                DataSet ds = new DataSet();
                SqlDataAdapter da = new SqlDataAdapter(cmd);
                da.Fill(ds, "Stages");
                AutoCompleteStringCollection col = new AutoCompleteStringCollection();
                int i = 0;
                for (i = 0; i <= ds.Tables[0].Rows.Count - 1; i++)
                {
                    col.Add(ds.Tables[0].Rows[i]["Stagename"].ToString());

                }
                txtStageName.AutoCompleteSource = AutoCompleteSource.CustomSource;
                txtStageName.AutoCompleteCustomSource = col;
                txtStageName.AutoCompleteMode = AutoCompleteMode.Suggest;

                con.Close();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        private void btnUpdate_Click(object sender, EventArgs e)
        {
            try
            {
                con = new SqlConnection(cs.ConDB);
                con.Open();

                string cb = "update Stages set StageName='" + txtStageName.Text + "' where ID=" + txtID.Text + "";
                cmd = new SqlCommand(cb);
                cmd.Connection = con;
                cmd.ExecuteReader();
                con.Close();
                st1 = lblUser.Text;
                st2 = "Updated the Stage '" + txtStageName.Text + "'";
                cf.LogFunc(st1, System.DateTime.Now, st2);
                MessageBox.Show("Successfully updated", "Record", MessageBoxButtons.OK, MessageBoxIcon.Information);
                Autocomplete();
                btnUpdate.Enabled = false;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        private void Reset()
        {
            txtStageName.Text = "";
            btnSave.Enabled = true;
            btnDelete.Enabled = false;
            btnUpdate.Enabled = false;
            txtStageName.Focus();
        }

        private void btnNew_Click(object sender, EventArgs e)
        {
            Reset();
        }

        private void btnGetData_Click(object sender, EventArgs e)
        {
            this.Hide(); 
            frmStageRecord frm = new frmStageRecord();
            frm.lblUser.Text = lblUser.Text;
            frm.Show();   
            frm.GetData();
        }

        private void frmStages_Load(object sender, EventArgs e)
        {

        }
    }
}
